/*
dotnet add package ModelContextProtocol --prerelease
dotnet add package ModelContextProtocol.AspNetCore --prerelease
dotnet add package Microsoft.Extensions.Hosting
*/

using ModelContextProtocol.Server;
using System.ComponentModel;

var builder = WebApplication.CreateBuilder(args);
builder.Services.AddMcpServer()
    .WithHttpTransport()
    .WithToolsFromAssembly();
var app = builder.Build();

app.MapMcp();

app.Run("http://localhost:3001");

[McpServerToolType]
public static class EchoTool
{
    [McpServerTool, Description("Echoes the message back to the client.")]
    public static string Echo(string message) => $"Yo!  You said '{message}'";
}

// Add a strongly-typed response class for weather
public record WeatherResponse(string City, int Temperature, int Humidity, string Condition);

[McpServerToolType]
public static class WeatherTool
{
    [McpServerTool, Description("Returns weather data as a typed object; framework will serialize to JSON.")]
    public static WeatherResponse GetWeather(string? city)
    {
        string cityName = city ?? string.Empty;
        int temperature = cityName.Length;
        int humidity = temperature * 5;
        var conditions = new[] { "Sunny", "Cloudy", "Rainy", "Windy" };
        string condition = conditions[temperature % conditions.Length];
        return new WeatherResponse(cityName, temperature, humidity, condition);
    }
}
