#!/bin/bash

# Telegram bot token and chat ID
BOT_TOKEN=""
CHAT_ID=""

HOSTNAME=$(hostname)

# Function to send Telegram message
send_telegram_message() {
    curl -s -X POST "https://api.telegram.org/bot$BOT_TOKEN/sendMessage" \
        -d chat_id="$CHAT_ID" \
        -d text="$1" > /dev/null
}

# Check real mounts and their utilization
df -h | grep -vE '^Filesystem|overlay|tmpfs|cdrom|udev' | awk '{ print $1 " " $5 " " $6 }' | while read -r line
do
    device=$(echo "$line" | awk '{print $1}')
    usage=$(echo "$line" | awk '{print $2}' | cut -d'%' -f1)
    mount=$(echo "$line" | awk '{print $3}')

    if [ "$usage" -gt 40 ]; then
        message="Diskspace warning on [$HOSTNAME]: $usage% utilication on $mount ($device)"
        send_telegram_message "$message"
    fi
done